# QuerySetRow()

Adds a row to a query, either by struct or array

**Introduced:** 5.3.8.120

```
QuerySetRow( query=query, rowNumber=number, rowData=any );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| query | query | Yes | query object to set row |  |
| rowNumber | number | No | position of the row to updated, otherwise a new row is added *Alias: row* | 0 |
| rowData | any | Yes | a struct or array *Alias: data* |  |

# Examples

```cfml
    testQuery=queryNew("id,name", "integer,varchar",
        [
            {"id"=1,"name"="jenifer"},
            {"id"=2,"name"="ajay"},
            {"id"=3,"name"="john"},
            {"id"=4,"name"="smith"}
        ]);

    querySetRow(testQuery, 3, {"id"=5,"name"="alpha"});
    writeDump(testQuery);
```







# Categories

[Queries](../../categories/query.md)

# See Also

[query.setRow()](../objects/query/setrow.md)