# QuerySetCell()

Sets a cell to a value. If no row number is specified, the cell on the last row is set.

You can add an entire row with data with [QueryAddRow()](queryaddrow.md).

```
QuerySetCell( query=query, column_name=string, value=any, row_number=number );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| query | query | Yes | Name of an executed query. *Alias: query* |  |
| column_name | string | Yes | Name of the column to populate. *Alias: columnName* |  |
| value | any | Yes | The value to populate the query cell with. |  |
| row_number | number | No | Query row number to populate. *Alias: row, number* | -9999 |

# Examples

```cfml
q = queryNew( "id,name");
QueryAddRow(q);

QuerySetCell(q, "id", 1, 1);
QuerySetCell(q, "name", "one", 1);

dump(q);
```







# Categories

[Queries](../../categories/query.md)

# See Also

[QueryAddRow()](queryaddrow.md), [query.addRow()](../objects/query/addrow.md), [query.setCell()](../objects/query/setcell.md), [<cfqueryparam>](../tags/queryparam.md)