# QueryRowSwap()

swaps one row of a query with an other.

**Introduced:** 6.0.0.17

```
QueryRowSwap( query=query, source=numeric, destination=numeric );
```

**Returns:** query

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| query | query | Yes | query object to swap rows |  |
| source | numeric | Yes | The row to swap. *Alias: sourceRow, src* |  |
| destination | numeric | Yes | The row to be swapped with. *Alias: destinationRow, dest, target* |  |

# Examples

```cfml
    qry = queryNew("id,name", "integer,varchar",
    [
        [1, "a"],
        [2, "b"],
        [3, "c"]
    ]);

    swapped = QueryRowSwap(qry,2,3)
    dump(swapped);
    dump(qry);
```







# Categories

[Queries](../../categories/query.md)

# See Also

[query.rowSwap()](../objects/query/rowswap.md)