# QueryRowByIndex()



**Introduced:** 5.3.4.34

```
QueryRowByIndex( query=query, index=string, defaultValue=numeric );
```

**Returns:** numeric

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| query | query | Yes | query object do get data from |  |
| index | string | Yes | Name of the index. |  |
| defaultValue | numeric | No | In case no matching index was found, this value is returned by the function, in case it is not set, the function will throw an exception. |  |

# Examples

```cfml
<cfscript>
    q_tag = queryNew("tag,id")
    tags = getTagList();
    loop collection="#tags.cf#" item="tag" {
        r = queryAddRow(q_tag);
        QuerySetCell(q_tag,"tag", tag, r);
        QuerySetCell(q_tag,"id", r, r);
    }
</cfscript>
<cfquery name="q_tags_indexed" indexName="tag" dbtype="query">
    select * from q_tag;
</cfquery>

<cfscript>
	dump(queryRowByIndex(q_tags_indexed, "cfquery", -1));
	default = {tag:"unknown", id:"-1"};
    	dump(queryRowDataByIndex(q_tags_indexed, "cfquery", default));
        dump(queryGetCellByIndex(q_tags_indexed, "id", "cfquery", -1));
</cfscript>
```







# Categories

[Queries](../../categories/query.md)

# See Also

[QueryGetCellByIndex()](querygetcellbyindex.md), [QueryRowDataByIndex()](queryrowdatabyindex.md), [query.rowByIndex()](../objects/query/rowbyindex.md), [Query Indexes](../../recipes/query-indexes.md)