# QueryRenameColumn()

Rename a column

**Introduced:** 6.0.0.57

```
QueryRenameColumn( query=query, column=string, newColumnName=string );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| query | query | Yes | Name of a query object. |  |
| column | string | Yes | Name of the column to rename. *Alias: columnName* |  |
| newColumnName | string | Yes | New name of the column. |  |

# Examples

```cfml
    qry= queryNew( "name , age" , "varchar , integer" , [ [ "Susi" , 24 ] , [ "Urs", 28 ] ]);

    writeOutput("Before changing the QueryColumn name : ");
    writeDump(qry);

    QueryRenameColumn( qry, "name", "employee" );

    writeOutput("After changing the QueryColumn name : ");
    writeDump(qry);
```







# Categories

[Queries](../../categories/query.md)

# See Also

[query.renameColumn()](../objects/query/renamecolumn.md)