# QueryReduce()

Iterates over every row of the given query and calls the closure with that row.

This function will reduce the query to a single value and will return this value.

```
QueryReduce( query=query, closure=function, initialValue=object );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| query | query | Yes | query to iterate *Alias: object* |  |
| closure | function | Yes | function/closure that implements the following constructor `function(any result, struct row[, number rowNumber, query query]){ return result;}` *Alias: function, callback, udf* |  |
| initialValue | object | No | initial value passed as part of the first closure call *Alias: initial, initalValue* |  |

# Examples

```cfml
	people = QueryNew( "name,dob,age", "varchar,date,int", [
	    [ "Susi", CreateDate( 1970, 1, 1 ), 0 ],
	    [ "Urs" , CreateDate( 1995, 1, 1 ), 0 ],
	    [ "Fred", CreateDate( 1960, 1, 1 ), 0 ],
	    [ "Jim" , CreateDate( 1988, 1, 1 ), 0 ]
	]);
	date=createDateTime(2016,3,13,17,0,0);
	totalAge = queryreduce( people,function(age=0, row, rowNumber, recordset ){
	    return age + DateDiff( 'yyyy', recordset.dob, date );
	});
	writeDump(totalAge);
```







# Categories

[Collections](../../categories/collection.md), [Queries](../../categories/query.md), [Threads](../../categories/thread.md)

# See Also

[query.reduce()](../objects/query/reduce.md)