# QueryNew()

Creates an empty query (query object).

```
QueryNew( columnNames=object, columnTypes=object, data=any );
```

**Returns:** query

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| columnNames | object | Yes | column names for the query created, allowed are comma-delimited string lists or an array. *Alias: names, columns, columnList* |  |
| columnTypes | object | No | column types for the query created, allowed are comma-delimited string lists or an array. *Alias: types, columnTypeList* |  |
| data | any | No | data to populate the new Query, an array of arrays or an array of structs. Example usage: - ```queryNew( "name,age", "varchar,numeric", [ [ "Susi", 20 ],[ "Urs", 24 ] ] );``` - ```queryNew( "name,age", "varchar,numeric", [ [ name:"Susi", age:20 ], [ name:"Urs", age:24 ] ] );``` - ```queryNew( "name,age", "varchar,numeric", { name:[ "Susi", "Urs" ], age:[ 20, 24 ] } );``` |  |

# Examples

```cfml
 	testQuery = queryNew( "name , age" , "varchar , numeric" , { name: [ "Susi" , "Urs" ] , age: [ 20 , 24 ] } );
 	dump(testQuery); 

	qry= queryNew( "name , age" , "varchar , numeric" , [ [ "Susi" , 20 ] , [ "Urs", 24 ] ]);
  	dump(qry);

 	qry= queryNew( "name , age" , "varchar , numeric" , [ { name: "Susi" , age: 20 }, { name: "Urs" , age: 24 } ] );
  	dump(qry);
```







# Categories

[Queries](../../categories/query.md)

# See Also

[Query](../objects/query.md)