# QueryMap()

Calls the given closure with every row in the query.

the function returns a query that contains all values returned by the closure.

```
QueryMap( query=query, closure=function, resQuery=query, parallel=boolean, maxThreads=number );
```

**Returns:** query

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| query | query | Yes | query to iterate |  |
| closure | function | Yes | filter can be a function/closure that implements the following constructor `function(struct row[, number rowNumber, query query]):struct`. The returned struct is used to fill a single query row. *Alias: function, callback, udf* |  |
| resQuery | query | No | Resulted query. *Alias: resultingQuery* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* | 20 |

# Examples

```cfml
	people = QueryNew( "name,dob,age", "varchar,date,int", [
		[ "Susi", CreateDate( 1970, 1, 1 ), 0 ],
		[ "Urs" , CreateDate( 1995, 1, 1 ), 0 ],
		[ "Fred", CreateDate( 1960, 1, 1 ), 0 ],
		[ "Jim" , CreateDate( 1988, 1, 1 ), 0 ]
	]);
	res = queryMap(people, function( row, rowNumber, recordset ){
		    row['age'] = DateDiff( 'yyyy', row.dob, CreateDate( 2016, 6, 9 ) )+1;
		    return row;
		});
	writeDump(res);
```







# Categories

[Collections](../../categories/collection.md), [Queries](../../categories/query.md), [Threads](../../categories/thread.md)

# See Also

[query.map()](../objects/query/map.md)