# QueryKeyExists()

Determines whether a specific column is present in a query.

```
QueryKeyExists( query=query, column=string );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| query | query | Yes | Query Object to test. |  |
| column | string | Yes | Key to be matched with the columns |  |

# Examples

```cfml
myQuery = queryNew("custID,custName");
writeDump(queryKeyExists(myQuery,"age"));
writeDump(queryKeyExists(myQuery,"custName"));
```







# Categories

[Queries](../../categories/query.md)

# See Also

[QueryColumnExists()](querycolumnexists.md), [query.keyExists()](../objects/query/keyexists.md)