# QueryColumnExists()

Determines whether a specific column is present in a query.

```
QueryColumnExists( query=query, column=string );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| query | query | Yes | Query object to check. |  |
| column | string | Yes | Name of the column. |  |

# Examples

```cfml
myQuery = queryNew("custID,custName");
writeDump(queryColumnExists(myQuery,"age"));
writeDump(queryColumnExists(myQuery,"custName"));
```







# Categories

[Queries](../../categories/query.md)

# See Also

[QueryKeyExists()](querykeyexists.md), [query.columnExists()](../objects/query/columnexists.md)