# QueryColumnData()

Returns all the data in a query for a given column

```
QueryColumnData( query=query, columnName=string, closure=function );
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| query | query | Yes | query object do get data from |  |
| columnName | string | Yes | name of the column returned |  |
| closure | function | No | UDF/Closure that call with the values from column *Alias: function, callback, udf* |  |

# Examples

```cfml
myQuery = QueryNew( '' );
names = [ 'xxxx','yyyy'];
queryAddColumn( myQuery,'name','varchar',names );
result = queryColumnData( myQuery,'name' );
writeDump(result);
```







# Categories

[Queries](../../categories/query.md)

# See Also

[ValueArray()](valuearray.md), [ValueList()](valuelist.md), [query.columnData()](../objects/query/columndata.md)