# QueryAddRow()

Adds rows to a query, either empty row(s) or you can add a row with data.

The number returned is the new row count of the query.

Lucee 6 changed the return value for the member function `.addrow()` from the number of rows, to the modified query, matching ACF

```
QueryAddRow( query=query, numberOrData=any );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| query | query | Yes | Name of an executed query. |  |
| numberOrData | any | No | Number of rows to add to the query or a struct/array containing the data to populate the row. Examples: - ```queryAddRow(qry, 3);``` - ```queryAddRow(qry, [ "Susi", 20] );``` - ```queryAddRow(qry, { name: "Susi", age: 20 } );``` *Alias: number, data* | 1 |

# Examples

```cfml
myQuery    = queryNew( "id,name");
addedRows  = queryAddRow(myQuery, 3); // will return 3

queryAddRow(myQuery, [17,'added via array notation']);

anotherRow = queryAddRow(myQuery);    // will return 4

queryAddRow(myQuery, {
    id:18,
    name:'added via struct notation'
});
dump(myQuery);
```







# Categories

[Queries](../../categories/query.md)

# See Also

[QuerySetCell()](querysetcell.md), [query.addRow()](../objects/query/addrow.md), [query.setCell()](../objects/query/setcell.md)