# QueryAddColumn()

Adds a column to a query and populates its rows with the
contents of an one-dimensional array.

Pads query columns, if necessary, to ensure that all columns have the same number of rows.

```
QueryAddColumn( query=query, column=string, datatype_or_array=any, array=any );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| query | query | Yes | Name of a query object. |  |
| column | string | Yes | Name of the new column. *Alias: columnName* |  |
| datatype_or_array | any | No | Column data type. *Alias: datatype* |  |
| array | any | No | Name of an array whose elements populate the new column. |  |

# Examples

```cfml
qry=queryNew("aaa,bbb");

QueryAddRow(qry);
	QuerySetCell(qry,"aaa","1.1");
	QuerySetCell(qry,"bbb","1.2");
QueryAddRow(qry);
	QuerySetCell(qry,"aaa","2.1");
	QuerySetCell(qry,"bbb","2.2");

QueryAddColumn(qry,"ccc",listToArray("3.1,3.2"));
QueryAddColumn(qry,"ddd","integer",listToArray("4.1,4.2"));

writeDump(qry.columnList);
```







# Categories

[Queries](../../categories/query.md)

# See Also

[query.addColumn()](../objects/query/addcolumn.md)