# Query()

Create and populate a query object.

You can set the column name as the argument name you pass in and pass in the data as an array.

Each item in the array represents a different row in that column.

For example: `query(columnName1:[1,2,3],columnName2:[4,5,6])`

```
Query( );
```

**Returns:** query

*This function takes zero or more dynamic arguments. See examples for details.*

# Examples

```cfml
myquery = query(
  columnName1: [1,2,3],
  columnName2: [4,5,6]
);
dump(myquery);

column = "size";
values = ["small","medium","large"];
myquery = query(
  "#column#": values,
  column: values
);
dump(myquery);

myquery = query(
  columnName: []
);
dump(var=myquery, label="empty query");

myquery = query();
dump(var=myquery, label="no-argument query");
```







# Categories

[Cache](../../categories/cache.md), [Queries](../../categories/query.md)

# See Also

[<cfquery>](../tags/query.md)