# PrecisionEvaluate()

Evaluates one or more string expressions using an increased memory size for arithmetic operations. This improves the accuracy of floating point calculations. For more details, see this video explanation: [https://www.youtube.com/watch?v=g7A8OFi1mdU](https://www.youtube.com/watch?v=g7A8OFi1mdU).

**The expression(s) must be passed as strings**, to avoid large numbers being converted to normal cfml numbers (which have limits on there precision) before they are evaluated.

```
PrecisionEvaluate( );
```

**Returns:** any

*This function takes zero or more dynamic arguments. See examples for details.*

# Usage Notes

You can see in the examples that use of PrecisionEvaluate() uses a 'string'.
Despite using the PrecisionEvaluate function, if you omit the quotes, Lucee will perform "normal" math on the arguments, supplied.

# Examples

```cfml
dump( ( 59+10.99 ) * 100 );                        // 6998.999999999999
dump( PrecisionEvaluate( "( 59+10.99 ) * 100" ) ); // 6999
```







# Categories

[Numbers](../../categories/number.md), [Math](../../categories/math.md)

# See Also

[Mathematical Precision](../../recipes/mathematical-precision.md)