# ParseNumber()

Parses the string argument as a numeric value.

```
ParseNumber( number=string, radix=string );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| number | string | Yes | the String containing the numeric representation to be parsed |  |
| radix | string | No | the radix to be used while parsing (bin,oct,dec,hex) |  |

# Examples

```cfml
  number = "1000";

  echo(ParseNumber(number, "dec")); // 1000
  echo(ParseNumber(number, "bin")); // 8
  echo(ParseNumber(number, "oct")); // 512
  echo(ParseNumber(number, "hex")); // 4096
```







# Categories

[Numbers](../../categories/number.md), [Parsing](../../categories/parsing.md)

# See Also

[LSParseNumber()](lsparsenumber.md), [Val()](val.md)