# PagePoolClear()

Purges the cfml code (cfm, cfcs) from the cache of compiled bytecode (aka the Page Pool)

**This function no longer recommended**.

Please use [InspectTemplates()](inspecttemplates.md) instead, which only marks this cache as being dirty, thus triggering a check on use, to see if the underlying cfml file has changed, which is extremely efficient both in terms of memory usage and CPU.

**Status:** deprecated

```
PagePoolClear( force=boolean );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| force | boolean | No | When set to `false` (default in Lucee 6.2.1+), this function behaves like inspectTemplates(), which only reloads changed pages. When set to `true`, it reverts to the original behavior of forcibly clearing all pages from memory pools, causing unnecessary reloading of unchanged pages. |  |

# Usage Notes

This only clears the cache for the **current** Application, plus all Server and Web Context mappings. 

Other per Application mappings are not cleared

# Examples

```cfml
  result = PagePoolClear();
  echo(result); // page pool has been cleared
```







# Categories

[Cache](../../categories/cache.md), [Lucee Server related Tags, Functions and Guides](../../categories/server.md)

# See Also

[InspectTemplates()](inspecttemplates.md), [PagePoolList()](pagepoollist.md), [SystemCacheClear()](systemcacheclear.md)