# ObjectEquals()

Compares simply and complex objects for equality, by default, string comparison is not case sensitive

```
ObjectEquals( left=any, right=any, caseSensitive=boolean );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| left | any | Yes | left operand *Alias: param1, clientObject* |  |
| right | any | Yes | right operant *Alias: param2, originalObject* |  |
| caseSensitive | boolean | No | Use case sensitive string comparison | false |

# Examples

```cfml
object1 = { id: 1, name: 'Lucee' };
object2 = { id: 1, name: 'Lucee' };
object3 = { id: 1, name: 'LUCEE' };
object4 = { id: 1, name: 'Lucee', type: "language" };
dump(ObjectEquals(left = object1, right = object2)); // true
dump(ObjectEquals(left = object1, right = object4)); // false
//By default caseSensitive = false
dump(ObjectEquals(left = object1, right = object3)); //true
//After caseSensitive = true
dump(ObjectEquals(left = object1, right = object3, caseSensitive = true)); //false
```







# Categories

[Objects](../../categories/object.md), [Decision logic](../../categories/decision.md)

# See Also

[ObjectSave()](objectsave.md)