# NumberFormat()

Creates a custom-formatted number value. For international number formatting use [LSNumberFormat()](lsnumberformat.md).

[mask - quickly]

- _,9 Digit placeholder; . decimal point; 0 Pads with zeros;
- ( ) less than zero, puts parentheses around the mask
- + plus sign before positive number minus before negative
- \- a space before positive minus sign before negative
- , Separates every third decimal place with a comma.
- L,C Left-justifies or center-justifies number
- $ dollar sign before formatted number.
- ^ Separates left and right formatting.

```
NumberFormat( number=any, mask=string );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| number | any | Yes | A number. |  |
| mask | string | No | _ = optional digit . = decimal point 0 = mandatory digit |  |

# Examples

```cfml
dump(numberFormat(1.234,'__.00')); // 1.23
dump(numberFormat(1234,'__.00')); // 1234.00
// 0 and 9 mask
dump(numberFormat(123,'00000'));
dump(numberFormat(123,'99999'));
dump(numberFormat(123.12,'99.99999'));
// _ mask
dump(numberFormat(123,'_____'));
dump(numberFormat(123,'_.___'));
dump(numberFormat(11.10,'__.000'));
// + & - mask
dump(numberFormat(123,'+'));
dump(numberFormat(-123,'-'));
 // , comma
dump(numberFormat(123,','))
dump(numberFormat(123456,','))
// L,C mask
dump(NumberFormat( 1, "L999" ));
dump(NumberFormat( 1, "C000" ));
```







# Categories

[Formatting](../../categories/formatting.md), [Numbers](../../categories/number.md), [Strings](../../categories/string.md)

# See Also

[LSNumberFormat()](lsnumberformat.md), [any.numberFormat()](../objects/any/numberformat.md)