# Minute()

Extracts the minute value from a date/time object in the range 0-59.

```
Minute( date=datetime, timezone=timezone );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| date | datetime | Yes | date object; for example, `now()` |  |
| timezone | timezone | No | A datetime object is independent of a specific timezone; it is only an offset in milliseconds from `1970-1-1 00.00:00 UTC` (Coordinated Universal Time). The timezone only comes into play when you need specific information like hours in a day, minutes in a hour or which day it is as these calculations depend on the timezone. A timezone must be specified in order to translate the date object to something else. If you do not provide the timezone in the function call, it will default to the timezone specified in the Lucee Administrator (Settings/Regional), or the timezone specified for the current request using the function [setTimezone()](settimezone.md). You can find a list of all available timezones in the Lucee administrator (Settings/Regional). Some examples of valid timezones include: - AGT (for time in Argentina) - Europe/Zurich (for time in Zurich/Switzerland) - HST (Hawaiian Standard Time in the USA) - JVM (JVM / Server Default Timezone) |  |

# Examples

```cfml
<cfoutput>
It is minute #minute(Now(), "Australia/Sydney")# of the day in Sydney.
</cfoutput>
```







# Categories

[Date and time](../../categories/datetime.md)

# See Also

[datetime.minute()](../objects/datetime/minute.md)