# Metaphone()

Metaphone is a phonetic algorithm, an algorithm published in 1990 for indexing words by their English pronunciation.

The algorithm produces variable length keys as its output, as opposed to Soundex's fixed-length keys.

Similar sounding words share the same keys.

```
Metaphone( str=string );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| str | string | Yes | The input string |  |

# Examples

```cfml
// reduces names to a key or code based on their English pronunciation, such that similar sounding names share the same key.
name1 = metaphone(str = "Smith");
name2 = metaphone(str = "Smythe");
name3 = metaphone(str = "Smithfield");
dump(name1); // SM0
dump(name2); // SM0
dump(name3); // SM0F
```







# Categories

[Strings](../../categories/string.md)

# See Also

[Soundex()](soundex.md)