# MavenLoad()

Loads all JAR files from one or more Maven endpoints and makes them available for use within the Lucee server environment. 
This function can be used to load dependencies, including transitive ones, for example at server startup.

### Example Usage of MavenLoad Function

The `MavenLoad` function allows you to load JAR files from Maven repositories, including all transitive dependencies. 
This is particularly useful during server startup to ensure that all required libraries are available.

#### Example Input as an Array of Structs:

```cfml
mavenLoad([
{
"groupId": "org.slf4j",
"artifactId": "slf4j-api",
"version": "1.7.32"
}
]);
```

**Introduced:** 6.2.0.151

```
MavenLoad( input=any );
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| input | any | Yes | A struct or an array of structs specifying the Maven coordinates, including groupId, artifactId, and version. *Alias: data, endpoint* |  |

# Examples

*There are currently no examples for this function*







# Categories

[Java](../../categories/java.md)

# See Also

[CreateObject()](createobject.md), [MavenInfo()](maveninfo.md), [<cfimport>](../tags/import.md)