# MavenInfo()

Retrieves information about a Maven artifact and its dependencies.

This function allows you to query details about a specific Maven artifact by providing its coordinates (groupId, artifactId, and optionally version).

It returns a query containing information about the artifact itself and all of its dependencies based on the specified scope.

The returned query includes columns for:

- **groupId**: The group identifier of the artifact
- **artifactId**: The artifact identifier
- **version**: The version of the artifact
- **scope**: The scope of the dependency (compile, provided, runtime, test, system)
- **optional**: Whether the dependency is optional
- **checksum**: Checksum information
- **url**: URL where the artifact can be found
- **path**: Local file path to the artifact

This function is useful for debugging classloading issues, understanding dependency trees, or gathering information about the libraries your application depends on.

**Introduced:** 7.0.0.136

```
MavenInfo( groupId=string, artifactId=string, version=string, scopes=array, includeOptional=boolean, validateURL=boolean );
```

**Returns:** query

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| groupId | string | Yes | The Maven group identifier that specifies the namespace for the artifact. |  |
| artifactId | string | Yes | The Maven artifact identifier that specifies the name of the artifact. |  |
| version | string | Yes | The specific version of the Maven artifact to query. |  |
| scopes | array | No | The dependency scopes to consider when retrieving dependencies. this is an array containing all scopes you wanna include in the resulting query. Valid values are: - compile - provided - runtime - test - system Default are all scopes excluding test. |  |
| includeOptional | boolean | No | If true, includes optional dependencies in the results. If false, excludes dependencies marked as optional from the query results. | true |
| validateURL | boolean | No | A Maven artifact can be provided from different repositories, not all repositories provide all artifacts. if set to false, Lucee simply picks the most likely repository. If set to true, Lucee checks all possibilities, what can take a while, so only set to true, if really needed. *Alias: validate* | false |

# Examples

### Simple example for MavenInfo

```cfml
dump(mavenInfo("com.icegreen","greenmail","2.1.3")); // requires Lucee 7+
```







# Categories

[Java](../../categories/java.md), [Lucee Server related Tags, Functions and Guides](../../categories/server.md)

# See Also

[MavenLoad()](mavenload.md)