# MarkdownToHtml()

Transforms Markdown formatted String into HTML.

**Introduced:** 6.0.0.150

```
MarkdownToHtml( string=string, safeMode=boolean, encoding=string );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | A Markdown formatted string or a path to a file containf a markdown formatted string to convert to HTML *Alias: markdown* |  |
| safeMode | boolean | No | If set to true it does escape unsafe HTML tags *Alias: safe* | false |
| encoding | string | No | Charset, only used in case the argument markdown contains a file path *Alias: charset* |  |

# Examples

```cfml
nl= chr(10);
dNL= nl & nl;

markdownString="" & 
"## Heading1"  & dNL &
"###### Simple Paragraph"  & dNL &
"Some simple paragraph with a simple text"  & dNL &
"###### Ordered List"  & dNL &
"- First item" & nl &
"- Second item" & nl &
"- Third item" & dNL &
"###### Some Blockquotes"  & dNL &
"> This is some blockquoted text" & nl &
">> Blockquoted text with indentation" & dNL;

echo( markdownToHtml( markdownString) );
```







# Categories

[Strings](../../categories/string.md)

# See Also

[string.MarkdownToHTML()](../objects/string/markdowntohtml.md)