# LsWeek()

Returns the week number in the year of the date referenced, based on the local influence.

Not everywhere does the week begin on Monday by definition.

```
LsWeek( date=datetime, locale=locale, timezone=timezone );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| date | datetime | Yes | date object; for example, [now()](now.md) |  |
| locale | locale | No | Locale to use instead of the locale of the page when processing the function |  |
| timezone | timezone | No | A datetime object is independent of a specific timezone; it is only an offset in milliseconds from `1970-1-1 00.00:00 UTC` (Coordinated Universal Time). The timezone only comes into play when you need specific information like hours in a day, minutes in a hour or which day it is as these calculations depend on the timezone. A timezone must be specified in order to translate the date object to something else. If you do not provide the timezone in the function call, it will default to the timezone specified in the Lucee Administrator (Settings/Regional), or the timezone specified for the current request using the function [setTimezone()](settimezone.md). You can find a list of all available timezones in the Lucee administrator (Settings/Regional). Some examples of valid timezones include: - AGT (for time in Argentina) - Europe/Zurich (for time in Zurich/Switzerland) - HST (Hawaiian Standard Time in the USA) - JVM (JVM / Server Default Timezone) |  |

# Examples

```cfml
	Dump(lsweek("{ts '2020-12-27 0:0:0'}",'#getLocale()#','CET'));
	Dump(lsweek("{ts '2020-12-27 0:0:0'}",'#getLocale()#'));

	date = createDateTime(2022,01,17,12,0,0,0,"UTC"); 
	// in CH Monday is the first day of the week
	Dump(lsWeek(date, "DE_CH", "Europe/Zurich"));
	// in Bagdad Monday is the third day of the week
	Dump(lsWeek(date, "ar_IQ", "Asia/Baghdad"));
	// in the US Monday is the second day of the week
	Dump(lsWeek(date, "EN_US", "America/Los_Angeles"));
```







# Categories

[Date and time](../../categories/datetime.md), [Internationalization](../../categories/internationalization.md)

# See Also

[Week()](week.md)