# LSUCase()

Converts the alphabetic characters in a specified string to uppercase, respecting locale-specific casing rules. 

This is particularly important for languages where the standard/ typical (i.e. western) case conversion rules do not apply, ensuring accurate and culturally correct text processing. 

The function defaults to the current page's locale if no locale is specified.

**Introduced:** 6.1.0.37

```
LSUCase( string=string, locale=locale );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | The string to be converted to uppercase. This can be a direct string value or a variable that contains the string. |  |
| locale | locale | No | Optional. Specifies the locale to use for the conversion, overriding the default locale of the page. This should be a locale code string (e.g., `en-US` for American English or `tr-TR` for Turkish). |  |

# Examples

```cfml
<cfset text = "istanbul ısparta">
<cfoutput>
  Turkish upper case: #LSUCase(text, "tr-TR")#<br>
  Normal upper case: #UCase(text)#<br>
</cfoutput>
```







# Categories

[Internationalization](../../categories/internationalization.md)

# See Also

[LSLCase()](lslcase.md), [UCase()](ucase.md)