# LSTimeFormat()

Formats a time string to a given output using the current locale.

```
LSTimeFormat( time=any, mask=string, locale=locale, timezone=timezone );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| time | any | Yes | date object; for example, [now()](now.md) |  |
| mask | string | No | Mask that has to be used for formatting. The function follows Java date time mask. For details, see the Java documentation section [Date and Time Patterns](https://docs.oracle.com/javase/8/docs/api/java/text/SimpleDateFormat.html). | short |
| locale | locale | No | Locale to use instead of the locale of the page when processing the function |  |
| timezone | timezone | No | A datetime object is independent of a specific timezone; it is only an offset in milliseconds from `1970-1-1 00.00:00 UTC` (Coordinated Universal Time). The timezone only comes into play when you need specific information like hours in a day, minutes in a hour or which day it is as these calculations depend on the timezone. A timezone must be specified in order to translate the date object to something else. If you do not provide the timezone in the function call, it will default to the timezone specified in the Lucee Administrator (Settings/Regional), or the timezone specified for the current request using the function [setTimezone()](settimezone.md). You can find a list of all available timezones in the Lucee administrator (Settings/Regional). Some examples of valid timezones include: - AGT (for time in Argentina) - Europe/Zurich (for time in Zurich/Switzerland) - HST (Hawaiian Standard Time in the USA) - JVM (JVM / Server Default Timezone) |  |

# Examples

```cfml
	list = "arabic (united arab emirates),arabic (jordan),hindi(India),arabic (syria),spanish (panama)";
	loop list="#list#" index="locale" delimiters="," {
		oldlocale = setLocale(locale);
		writeOutput("<h3>#locale#</h3>");
		writeoutput(lsTimeFormat(now()));writeOutput("<br>");
		writeoutput(lsTimeFormat(now(), 'hh:mm:ss'));writeOutput("<br>");
		writeoutput(lsTimeFormat(now(), 'hh:mm:sst'));writeOutput("<br>");
		writeoutput(lsTimeFormat(now(), 'hh:mm:sstt'));writeOutput("<br>");
		writeoutput(lsTimeFormat(now(), 'HH:mm:ss'));
	}
```







# Categories

[Date and time](../../categories/datetime.md), [Formatting](../../categories/formatting.md), [Internationalization](../../categories/internationalization.md), [Strings](../../categories/string.md)

# See Also

[TimeFormat()](timeformat.md), [datetime.LSTimeFormat()](../objects/datetime/lstimeformat.md)