# LSParseNumber()

Converts a string that is a valid numeric representation in
the current locale into a formatted number.

```
LSParseNumber( number=string, locale=locale );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| number | string | Yes | A string or a variable that contains one *Alias: string* |  |
| locale | locale | No | Locale to use instead of the locale of the page when processing the function |  |

# Examples

```cfml
	writeOutput(lsParseNumber("25,000") & "<br>");
	writeOutput(lsParseNumber("0012.456") & "<br>");
	writeOutput(lsParseNumber(numberFormat(35,'000.00')) & "<br>");
	writeOutput(lsParseNumber(01123) & "<br>");
	writeOutput(lsParseNumber(23000) & "<br>");
```







# Categories

[Numbers](../../categories/number.md), [Strings](../../categories/string.md), [Parsing](../../categories/parsing.md), [Internationalization](../../categories/internationalization.md)

# See Also

[ParseNumber()](parsenumber.md)