# LSParseDateTime()

Converts a string that is a valid date/time representation in the current locale into a date/time object.

```
LSParseDateTime( date=object, locale=locale, timezone=string, format=string );
```

**Returns:** datetime

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| date | object | Yes | A string in a format that is readable in the current locale. |  |
| locale | locale | No | Locale to use instead of the locale of the page when processing the function |  |
| timezone | string | No | A datetime object is independent of a specific timezone; it is only an offset in milliseconds from `1970-1-1 00.00:00 UTC` (Coordinated Universal Time). The timezone only comes into play when you need specific information like hours in a day, minutes in a hour or which day it is as these calculations depend on the timezone. A timezone must be specified in order to translate the date object to something else. If you do not provide the timezone in the function call, it will default to the timezone specified in the Lucee Administrator (Settings/Regional), or the timezone specified for the current request using the function [setTimezone()](settimezone.md). You can find a list of all available timezones in the Lucee administrator (Settings/Regional). Some examples of valid timezones include: - AGT (for time in Argentina) - Europe/Zurich (for time in Zurich/Switzerland) - HST (Hawaiian Standard Time in the USA) - JVM (JVM / Server Default Timezone) *Alias: timezone* |  |
| format | string | No | Mask that has to be used for formatting. The function follows Java date time mask. For details, see the Java documentation section [Date and Time Patterns](https://docs.oracle.com/javase/8/docs/api/java/text/SimpleDateFormat.html). |  |

# Examples

```cfml
dump(lsParseDateTime( "12/30/08",'english (us)'));
dump(lsParseDateTime( "Feb 29, 2008",'english (us)'));
dump(lsParseDateTime( "February 29, 2008",'english (us)'));
dump(lsParseDateTime( "Friday, February 29, 2008",'english (us)'));

```







# Categories

[Date and time](../../categories/datetime.md), [Internationalization](../../categories/internationalization.md), [Parsing](../../categories/parsing.md)

# See Also

[Custom Date and Time format for a Locale using .df files](../../guides/Various/locale-df-files.md), [ParseDateTime()](parsedatetime.md)