# LSParseCurrency()

Converts a locale-specific currency string into a formatted
number. Attempts conversion by comparing the string with each
the three supported currency formats (none, local,
international) and using the first that matches.

```
LSParseCurrency( string=string, locale=locale );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | A locale-specific string *Alias: currency, number* |  |
| locale | locale | No | Locale to use instead of the locale of the page when processing the function |  |

# Examples

```cfml
<cfoutput>
	#LSParseCurrency(4.5)#<br>
	#LSParseCurrency("$4.50")#<br>
	#LSParseCurrency("£4.50", "English (UK)")#
</cfoutput>
```







# Categories

[Currency features](../../categories/currency.md), [Strings](../../categories/string.md), [Parsing](../../categories/parsing.md), [Internationalization](../../categories/internationalization.md)