# LSLCase()

Converts the alphabetic characters in a specified string to lowercase, respecting locale-specific casing rules. 

This is particularly important for languages where the standard lowercase conversion rules do not apply, ensuring accurate and culturally correct text processing. 

The function defaults to the current page's locale if no locale is specified.

**Introduced:** 6.1.0.37

```
LSLCase( string=string, locale=locale );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | The string to be converted to lowercase. This parameter can accept either a string literal or a variable that holds the string content. |  |
| locale | locale | No | Optional. Allows specifying a different locale for the conversion, superseding the page's default locale. This argument accepts a locale identifier, such as `fr-CA` for Canadian French or `de-DE` for German in Germany. |  |

# Examples

```cfml
<cfset text = "Istanbul İZMİR">
<cfoutput>
  Turkish lower case: #LSLCase(text, "tr-TR")#<br>
  Normal lower case: #LCase(text)#<br>
</cfoutput>
```







# Categories

[Internationalization](../../categories/internationalization.md)

# See Also

[LCase()](lcase.md), [LSUCase()](lsucase.md)