# LSIsNumeric()

Determines whether a string is a valid representation of a
number in the current locale.

```
LSIsNumeric( number=string, locale=locale );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| number | string | Yes | A string or a variable that contains one *Alias: string* |  |
| locale | locale | No | Locale to use instead of the locale of the page when processing the function |  |

# Examples

```cfml
	writeoutput(lsIsNumeric('123') & "<br>");
	writeoutput(lsIsNumeric('five') & "<br>");
	writeoutput(lsIsNumeric('3.21') & "<br>");
	writeoutput(lsIsNumeric('0012') & "<br>");
	writeoutput(lsIsNumeric('00.01'));
	writeoutput(lsIsNumeric('1.321,00') & "<br>"); // false
	writeoutput(lsIsNumeric('1.321,00', "german") & "<br>"); // true
```







# Categories

[Decision logic](../../categories/decision.md), [Internationalization](../../categories/internationalization.md), [Numbers](../../categories/number.md)

# See Also

[IsNumeric()](isnumeric.md)