# LSIsDate()

Determines whether a string is a valid representation of a date/time value in the current locale.

```
LSIsDate( date=any, locale=locale, timezone=timezone );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| date | any | Yes | A string or a variable that contains one *Alias: date* |  |
| locale | locale | No | Locale to use instead of the locale of the page when processing the function |  |
| timezone | timezone | No | A datetime object is independent of a specific timezone; it is only an offset in milliseconds from `1970-1-1 00.00:00 UTC` (Coordinated Universal Time). The timezone only comes into play when you need specific information like hours in a day, minutes in a hour or which day it is as these calculations depend on the timezone. A timezone must be specified in order to translate the date object to something else. If you do not provide the timezone in the function call, it will default to the timezone specified in the Lucee Administrator (Settings/Regional), or the timezone specified for the current request using the function [setTimezone()](settimezone.md). You can find a list of all available timezones in the Lucee administrator (Settings/Regional). Some examples of valid timezones include: - AGT (for time in Argentina) - Europe/Zurich (for time in Zurich/Switzerland) - HST (Hawaiian Standard Time in the USA) - JVM (JVM / Server Default Timezone) |  |

# Examples

```cfml
orgLocale = getLocale();
setLocale(orgLocale);
writeDump(label:"Date.Month.year", var:lsIsDate("02.01.2018"));
writeDump(label:"year in two digits", var:lsIsDate("02.01.04"));
writeDump(label:"Month in string", var:lsIsDate("2. January 2018"));
writeDump(label:"Month/Date with Locale", var:lsIsDate("12/31/2008",'english (us)'));
writeDump(label:"Date/Month", var:lsIsDate("31/12/2018",'english (us)'));
writeDump(label:"Month Date, year", var:lsIsDate("Feb 29, 2020",'english (us)'));
writeDump(label:"Date Month year", var:lsIsDate("29 February 2020",'english (uk)'));
writeDump(label:"day, Date Month year", var:lsIsDate("Saturday, 29 February 2020",'english (uk)'));
writeDump(label:"Date-Month-year", var:lsIsDate("30-Feb-2020",'english (uk)'));
```







# Categories

[Date and time](../../categories/datetime.md), [Decision logic](../../categories/decision.md), [Internationalization](../../categories/internationalization.md)

# See Also

[IsDate()](isdate.md)