# LSIsCurrency()

Determines whether a string is a valid representation of a
currency amount in the current locale.

```
LSIsCurrency( number=string, locale=locale );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| number | string | Yes | A currency string *Alias: string, currency_number, currency* |  |
| locale | locale | No | Locale to use instead of the locale of the page when processing the function |  |

# Examples

```cfml
<cfoutput>
	#LSIsCurrency(4.5)#<br>
	#LSIsCurrency("$4.50")#<br>
	#LSIsCurrency("£4.50", "English (UK)")#
</cfoutput>
```







# Categories

[Currency features](../../categories/currency.md), [Strings](../../categories/string.md), [Formatting](../../categories/formatting.md), [Internationalization](../../categories/internationalization.md), [Decision logic](../../categories/decision.md)