# LSDateTimeFormat()

Formats a date string to a given output using the current locale.

```
LSDateTimeFormat( date=any, mask=string, locale=locale, timezone=timezone );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| date | any | Yes | date object |  |
| mask | string | No | Mask that has to be used for formatting. Date time formatting mask (case sensitive): - `a,..,aaaa`: AM/PM marker (see also "t" and "tt"; Example:AM) - `d`: Day in month, no leading zero for single-digit days (Example:3) - `dd`: Day in month, leading zero for single-digit days (Example:03) - `D`: Day in year, no leading zero for single-digit days (Example:4) - `DD`: Day in year, leading zero for single-digit days (Example:04) - `DDD`: Day in year, 2 leading zero for single-digit days (Example:004) - `E,EE,EEE`: Day of week as a three-letter abbreviation (Example:Tue) - `EEEE`: Day of week as its full name (Example:Tuesday) - `F`: Day of week in month, no leading zero for single-digit days (Example:4) - `FF`: Day of week in month, leading zero for single-digit days (Example:04) - `G,GG`: Era designator (Example:AD) - `h`: Hour in am/pm (1-12), no leading zero for single-digit hours (Example:3) - `hh`: Hour in am/pm (1-12), leading zero for single-digit hours (Example:03) - `H`: Hour in day (0-23), no leading zero for single-digit hours (Example:14) - `HH`: Hour in day (00-23), leading zero for single-digit hours (Example:14) - `k`: Hour in day (1-24), no leading zero for single-digit hours (Example:15) - `kk`: Hour in day (1-24), leading zero for single-digit hours (Example:15) - `K`: Hour in am/pm (0-11), no leading zero for single-digit hours (Example:2) - `KK`: Hour in am/pm (0-11), leading zero for single-digit hours (Example:02) - `l,L`: milliseconds, with no leading zeros (Example:3) - `ll,LL`: milliseconds, leading zero for single-digit days (Example:03) - `lll,LLL`: milliseconds, 2 leading zero for single-digit days (Example:003) - `m,M`: Month as digits, no leading zero for single-digit months (Example:6) - `mm,MM`: Month as digits, leading zero for single-digit months (Example:06) - `mmm,MMM`: Month as a three-letter abbreviation (Example:Jun) - `mmmm,MMMM`: Month as its full name (Example:June) - `n,N`: minutes in hour, no leading zero for single-digit minutes (Example:3) - `nn,NN`: minutes in hour, leading zero for single-digit minutes (Example:03) - `s,S`: seconds in minute, no leading zero for single-digit seconds (Example:3) - `ss,SS`: seconds in minute, leading zero for single-digit seconds (Example:03) - `t,T`: one-character time marker string (Example:P) - `tt,TT`: multiple-character time marker string (Example:PM) - `w`: Week in year, no leading zero for single-digit hours (Example:27) - `ww`: Week in year, leading zero for single-digit hours (Example:27) - `W`: Week in month, no leading zero for single-digit hours (Example:2) - `WW`: Week in month, leading zero for single-digit hours (Example:02) - `y,yy,yyy`: Year as last two digits, leading zero for single-digit (Example:09) - `yyyy`: Year represented by four digits (Example:2009) - `z,zz,zzz`: General time zone as a 3 to 4 letter abbreviation (Example:PST) - `zzzz`: General time zone as its full name (Example:Pacific Standard Time) - `Z,..,ZZZZ`: RFC 822 time zone (Example:-0800) The following masks can be used to format the full date and time and may not be combined with other masks: - `short`: equivalent to "m/d/y h:nn tt" - `medium`: equivalent to "mmm d, yyyy h:nn:ss tt" - `long`: medium followed by three-letter time zone; i.e. "mmmm d, yyyy h:nn:ss tt zzz" - `full`: equivalent to "dddd, mmmm d, yyyy h:nn:ss tt zz" - `ISO8601/ISO`: equivalent to "yyyy-mm-dd'T'HH:nn:ssXXX" - `ISOMillis/ISOMs/javascript`: Javascript style ISO date, equivalent to "yyyy-mm-dd'T'HH:nn:ss.SSSXXX" - `epoch`: Total seconds of a given date (Example:1567517664) - `epochms`: Total milliseconds of a given date (Example:1567517664000) | dd-MMM-yyyy HH:nn:ss |
| locale | locale | No | Locale to use instead of the locale of the page when processing the function |  |
| timezone | timezone | No | A datetime object is independent of a specific timezone; it is only an offset in milliseconds from `1970-1-1 00.00:00 UTC` (Coordinated Universal Time). The timezone only comes into play when you need specific information like hours in a day, minutes in a hour or which day it is as these calculations depend on the timezone. A timezone must be specified in order to translate the date object to something else. If you do not provide the timezone in the function call, it will default to the timezone specified in the Lucee Administrator (Settings/Regional), or the timezone specified for the current request using the function [setTimezone()](settimezone.md). You can find a list of all available timezones in the Lucee administrator (Settings/Regional). Some examples of valid timezones include: - AGT (for time in Argentina) - Europe/Zurich (for time in Zurich/Switzerland) - HST (Hawaiian Standard Time in the USA) - JVM (JVM / Server Default Timezone) |  |

# Examples

```cfml
	list = "arabic (united arab emirates),arabic (jordan),croatian (croatia),french (belgium),spanish (panama)";
	loop list="#list#" index="locale" delimiters="," {
		oldlocale = setLocale(locale);
		writeOutput("<h3>#locale#</h3>");
		writeoutput(lsdateTimeFormat(now()));writeOutput("<br>");
		writeoutput(lsdateTimeFormat(now(), 'hh:mm:ss'));writeOutput("<br>");
		writeoutput(lsdateTimeFormat(now(), 'hh:mm:sst'));writeOutput("<br>");
		writeoutput(lsdateTimeFormat(now(), 'hh:mm:sstt'));writeOutput("<br>");
		writeoutput(lsdateTimeFormat(now(), 'HH:mm:ss'));
	}
```







# Categories

[Date and time](../../categories/datetime.md), [Formatting](../../categories/formatting.md), [Internationalization](../../categories/internationalization.md), [Strings](../../categories/string.md)

# See Also

[DateTimeFormat()](datetimeformat.md), [datetime.LSDateTimeFormat()](../objects/datetime/lsdatetimeformat.md)