# LSDateFormat()

Formats a date string to a given output using the current sessions locale

```
LSDateFormat( date=any, mask=string, locale=locale, timezone=timezone );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| date | any | Yes | date object; for example, [now()](now.md) |  |
| mask | string | No | Characters that show how Lucee displays a date: - `d`: Day of the month as digits; no leading zero for single-digit days. - `dd`: Day of the month as digits; leading zero for single-digit days. - `ddd`: Day of the week as a three-letter abbreviation. - `dddd`: Day of the week as its full name. - `m`: Month as digits; no leading zero for single-digit months. - `mm`: Month as digits; leading zero for single-digit months. - `mmm`: Month as a three-letter abbreviation. - `mmmm`: Month as its full name. - `yy`: Year as last two digits; leading zero for years less than 10. - `yyyy`: Year represented by four digits. - `gg`: Period/era string. Ignored. Reserved. The following masks tell how to format the full date and cannot be combined with other masks: - `z`: Time zone in literal format, for example, IST - `Z`: Time zone in hours of offset (RFC 822 TimeZone), for example, +0530 - `X`: Time zone in hours of offset in ISO 8601 format. The following are the three ways of using 'X': - `X`: +05 - `XX`: +0530 - `XXX`: +5:30 - `short`: equivalent to m/d/y - `medium`: equivalent to mmm d, yyyy - `long`: equivalent to mmmm d, yyyy - `full`: equivalent to dddd, mmmm d, yyyy | medium |
| locale | locale | No | Locale to use instead of the locale of the page when processing the function |  |
| timezone | timezone | No | A datetime object is independent of a specific timezone; it is only an offset in milliseconds from `1970-1-1 00.00:00 UTC` (Coordinated Universal Time). The timezone only comes into play when you need specific information like hours in a day, minutes in a hour or which day it is as these calculations depend on the timezone. A timezone must be specified in order to translate the date object to something else. If you do not provide the timezone in the function call, it will default to the timezone specified in the Lucee Administrator (Settings/Regional), or the timezone specified for the current request using the function [setTimezone()](settimezone.md). You can find a list of all available timezones in the Lucee administrator (Settings/Regional). Some examples of valid timezones include: - AGT (for time in Argentina) - Europe/Zurich (for time in Zurich/Switzerland) - HST (Hawaiian Standard Time in the USA) - JVM (JVM / Server Default Timezone) |  |

# Examples

```cfml
	list = "arabic (syria),croatian (croatia),french (belgium),spanish (panama)";
	loop list="#list#" index="locale" delimiters="," {
	    oldlocale = setLocale(locale);
	    writeOutput("<h3>#locale#</h3>");
	    writeoutput(lsdateformat(now()));writeOutput("<br>");
	    writeoutput(now().lsdateformat('full'));writeOutput("<br>");
	    writeoutput(now().lsdateformat('short'));writeOutput("<br>");
	    writeoutput(now().lsdateformat('hh:mm:sstt'));writeOutput("<br>");
	    writeoutput(now().lsdateformat('long'));
	}
```







# Categories

[Date and time](../../categories/datetime.md), [Formatting](../../categories/formatting.md), [Internationalization](../../categories/internationalization.md), [Strings](../../categories/string.md)

# See Also

[DateFormat()](dateformat.md), [datetime.LSDateFormat()](../objects/datetime/lsdateformat.md)