# LSCurrencyFormat()

Formats a number in a locale-specific currency format.

```
LSCurrencyFormat( number=object, type=string, locale=locale, useBrackets=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| number | object | Yes | Currency value *Alias: currency_number* |  |
| type | string | No | * local: the currency format and currency symbol used in the locale. * international: the international standard currency format and currency symbol of the locale. * none: the currency format used in the locale without a currency symbol. | local |
| locale | locale | No | Locale to use instead of the locale of the page when processing the function |  |
| useBrackets | boolean | No | When a number is negative, by default, it is wrapped in brackets | true |

# Examples

```cfml
  amount = 100;

  locale = 'en_US';
  writeoutput(LSCurrencyFormat( amount, 'local', locale )); // $100.00
  writeoutput(LSCurrencyFormat( amount, 'international', locale )); // USD 100.00
  writeoutput(LSCurrencyFormat( amount, 'none', locale )); // 100.00

  locale = 'ja_JP';
  writeoutput(LSCurrencyFormat( amount, 'local', locale )); // ￥100
  writeoutput(LSCurrencyFormat( amount, 'international', locale )); // JPY 100
  writeoutput(LSCurrencyFormat( amount, 'none', locale )); // 100
```







# Categories

[Currency features](../../categories/currency.md), [Strings](../../categories/string.md), [Formatting](../../categories/formatting.md), [Internationalization](../../categories/internationalization.md)

# See Also

[DollarFormat()](dollarformat.md), [LSEuroCurrencyFormat()](lseurocurrencyformat.md)