# LogAllThreads()

Creates detailed thread stack trace logs in JSONL format for performance analysis and debugging.

This function captures stack traces from all running threads at specified intervals for a given duration.

It executes asynchronously, returning immediately after starting the logging process, making it ideal
for analyzing specific code segments by initiating logging just before the target code execution.

The output format is JSONL (JSON Lines), where each line represents a separate JSON object containing:

- Timestamp offset in milliseconds from 1/1/1970 00:00:00 UTC (Unix 0)
- Complete stack trace of each thread's current location

This data can be used for:

- Performance bottleneck identification
- Thread behavior analysis
- Deadlock detection
- Resource usage patterns

**Introduced:** 6.2.0.219

```
LogAllThreads( path=string, interval=number, duration=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| path | string | Yes | Full file path where the log will be written. The file should have a `.jsonl` extension for proper identification as a JSON Lines format file. The function will create the file if it doesn't exist, or append to it if it does. Example: `/var/log/lucee/thread_analysis.jsonl` |  |
| interval | number | No | The time interval (in milliseconds) between stack trace captures. Lower values provide more detailed analysis but generate larger log files and may impact performance. Recommended ranges: - 1-10ms: Very detailed analysis, higher overhead - 10-100ms: Balanced detail and performance - 100ms+: Lower detail, minimal performance impact | 0 |
| duration | number | No | Total duration (in milliseconds) for which the function will collect thread data. After this period, logging automatically stops. Common durations: - 1000-5000ms: Quick snapshots - 10000ms: Standard analysis period - 30000ms+: Extended analysis for complex operations | 10000 |

# Examples

*There are currently no examples for this function*







# Categories

[Debugging](../../categories/debugging.md), [Lucee Server related Tags, Functions and Guides](../../categories/server.md), [Threads](../../categories/thread.md)