# LoadAISession()

Restores an AI session from a serialized JSON string or struct. This function recreates an AI session with:

- Original configuration settings (temperature, limits, timeouts)
- Complete conversation history
- System message prompt

The function supports loading sessions by:

- AI engine name
- Engine ID (using `id:` prefix)
- Default engine (using `default:` prefix)

This function pairs with `SerializeAISession()` to provide persistence for AI conversations across requests or application restarts.

**Introduced:** 7.0.0.195

```
LoadAISession( name=string, data=any );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| name | string | Yes | Specifies which AI endpoint configuration to use. Can be provided in two formats: 1. Direct endpoint name: The name of an endpoint as defined in the Lucee Administrator (similar to how datasource names work) 2. Default reference: Using the format "default:category" to use the endpoint configured as the default for that specific category in the Lucee Administrator. Currently supported default categories: - exception: For exception analysis - documentation: For documentation tasks The endpoint configurations and their default category assignments are managed in the Lucee Administrator. *Alias: aiName, nameAI* |  |
| data | any | Yes | The serialized AI session data, which can be provided as either: 1. A JSON string previously generated by `SerializeAISession()` 2. A struct containing session configuration and conversation history Must contain the following keys: - `temperature`: The temperature setting for the AI responses - `limit`: The conversation size limit - `connectionTimeout`: Connection timeout in milliseconds - `socketTimeout`: Socket timeout in milliseconds - `systemMessage`: (Optional) System message that guides AI behavior - `history`: Array of conversation exchanges (questions and answers) Incomplete or improperly formatted data may cause initialization errors. |  |

# Examples

```cfml
//AI service name eg:test_ai
Ai_session = CreateAISession(name:'test_ai', systemMessage:"Answer as Slim Shady.");
result = SerializeAISession(Ai_session);
writeDump(LoadAISession('test_ai', result));

```







# Categories

[AI / LLM Integration](../../categories/ai.md)

# See Also

[SerializeAISession()](serializeaisession.md)