# LJustify()

Left justifies characters in a string of a specified length.

```
LJustify( string=string, length=number );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | A string or a variable that contains one |  |
| length | number | Yes | Length of field in which to justify string |  |

# Examples

```cfml
	s = "";
    res = lJustify(s, 4);
    writeDump(len(res)); // length is 4
    writeoutput("<pre>|#res#|</pre><hr>");

    s = "abc";
    res = lJustify(s, 10);
    writeDump(len(res)); // length is 10
    writeoutput("<pre>|#res#|</pre><hr>");

    s = "10";
    res = lJustify(s, 8);
    writeDump(len(res)); // length is 8
    writeoutput("<pre>|#res#|</pre>");

```







# Categories

[Formatting](../../categories/formatting.md), [Strings](../../categories/string.md)

# See Also

[RJustify()](rjustify.md), [string.lJustify()](../objects/string/ljustify.md)