# ListValueCount()

Counts instances of a specified value in a list. 

The search is case-sensitive.

```
ListValueCount( list=string, value=string, delimiter=string, includeEmptyFields=boolean );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| value | string | Yes | Item for which to search |  |
| delimiter | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiters* | , |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |

# Examples

```cfml
List = "lucee,ACF,luceeExt,lucee, ext,LUCEEEXT";
writeDump(ListValueCount(list, "lucee")); // It return's 2
writeDump(ListValueCount(list, "luceeExt")); // It return's 1 because it case sensitive
List2 = "lucee@ACF@luceeExt@lucee@ext@LUCEEEXT";
writeDump(ListValueCount(list2, "lucee", "@"));
```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[string.listValueCount()](../objects/string/listvaluecount.md)