# ListToArray()

Copies the elements of a list to an array.

```
ListToArray( list=string, delimiter=string, includeEmptyFields=boolean, multiCharacterDelimiter=boolean );
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| delimiter | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiters* | , |
| includeEmptyFields | boolean | No | If set to true, empty values are also included. Default is false. |  |
| multiCharacterDelimiter | boolean | No | specifying whether the delimiters parameter specifies a multi-character delimiter. The default is false. If this parameter is true, the delimiters parameter must specify a single delimiter consisting of multiple characters. This parameter enables the ListToArray function to convert a list such as the following to an array of color names: red:\|orange:\|yellow:\|green:\|blue:\|indigo:\|violet. | false |

# Examples

Simple example for listToArray function:
Uses the listToArray() function to retrieve a list as an array

```cfml
list = "red,green,orange";
getArray = listToArray(list);
someJSON = serializeJSON(getArray);
writeOutput(someJSON);
```

Expected Result: `["red", "green", "orange"]`

Example for listToArray function with delimiter:
Uses the listToArray() function with a semicolon delimiter to retrieve a list as an array

```cfml
list = "coldfusion;php;java;sql";
getArray = listToArray(list,";");
someJSON = serializeJSON(getArray);
writeOutput(someJSON);
```

Expected Result: `["coldfusion", "php", "java", "sql"]`

Example for listToArray function with includeEmptyFields:
If includeEmptyFields is true, empty value add in array elements

```cfml
list = "coldfusion;php;;java;sql";
getArray = listToArray(list,";",true);
someJSON = serializeJSON(getArray);
writeOutput(someJSON);
```

Expected Result: `["coldfusion", "php", " ", "java", "sql"]`

Example for listToArray function with multiCharacterDelimiter:
Uses the listToArray() function to retrieve a list as an array with multiCharacterDelimiter

```cfml
list = "coldfusion,php,|test,java,|sql";
getArray = listToArray(list,",|",false,true);
someJSON = serializeJSON(getArray);
writeOutput(someJSON
);
```

Expected Result: `["coldfusion,php", "test,java", "sql"]`







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md), [Arrays](../../categories/array.md)

# See Also

[string.listToArray()](../objects/string/listtoarray.md)