# ListSort()

Sorts list elements according to a sort type and sort order.

```
ListSort( list=string, sort_type=string, sort_order=string, delimiters=string, includeEmptyFields=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| sort_type | string | No | there are different sort types: - numeric (sort by number) - text (sorts text alphabetically and case sensitive) - textnocase (sorts text alphabetically and ignore case sensitivity) *Alias: sortType* | textNoCase |
| sort_order | string | No | sort direction: - asc(default): ascending sort order - desc: descending sort order | asc |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* | , |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |

# Examples

### Simple example for listSort() with type numeric,text(case-sensitive) & textnocase(case-insensitive)

```cfml

listNumeric="4,-16,2,15,-5,7,11";
writeOutput(listsort(listNumeric,"numeric","asc"));
writeOutput("<br><br>");
writeOutput(listsort("Adobe/coldfusion/Lucee/15/LAS","text","desc","/"));
writeOutput("<br><br>");
writeOutput(listsort("Adobe,coldfusion,lucee,15,LAS","textnocase","asc"));
writeOutput("<br><br>");

//Member function
strList="Lucee,ColdFusion,LAS,SUSI,AdoBe";
writeDump(strlist.listSort("textnocase","asc"));

```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md), [Sorting](../../categories/sort.md)

# See Also

[string.listSort()](../objects/string/listsort.md)