# ListSome()

This function calls a given closure/function with every element in a given string list and returns true, if one of the closure calls returns true.

```
ListSome( list=string, closure=function, delimiter=string, includeEmptyFields=boolean, multiCharacterDelimiter=boolean, parallel=boolean, maxThreads=number );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | string list to iterate *Alias: string* |  |
| closure | function | Yes | function/closure that implements the following constructor [function(any value, numeric index,string list, string delimiter):boolean]. *Alias: function, callback, udf* |  |
| delimiter | string | No | delimiter used to separate the string list | , |
| includeEmptyFields | boolean | No | include empty fields or not | false |
| multiCharacterDelimiter | boolean | No | specifying whether the delimiters parameter specifies a multi-character delimiter. If this parameter is true, the delimiters parameter must specify a single delimiter consisting of multiple characters. This parameter enables the ListToArray function to convert a list such as the following to an array of color names: red:\|orange:\|yellow:\|green:\|blue:\|indigo:\|violet. | true |
| parallel | boolean | No | execute closures parallel | false |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* | 20 |

# Examples

```cfml
list=",,a,,b,c,,e,f";
// base test
res=ListSome(list, function(value ){return value =='a';},',',false,true, true);
writeDump(res);
res=ListSome(list, function(value ){return value =='z';},',',false,true,false);
writeDump(res);
```







# Categories

[Lists](../../categories/list.md), [Collections](../../categories/collection.md), [Threads](../../categories/thread.md)

# See Also

[string.listSome()](../objects/string/listsome.md)