# ListSetAt()

Replaces the contents of a list element.

```
ListSetAt( list=string, position=number, value=string, delimiters=string, includeEmptyFields=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| position | number | Yes | Position at which to set a value. The first list position is 1. |  |
| value | string | Yes | An element or a list of elements to set. |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* | , |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |

# Examples

```cfml
list1 = ",a,b,c,d,e"
Dump(listSetAt(list1,"2", "Z"));
list2 = ",a||b||c||d||e"
Dump(listSetAt(list2,"2", "Z", "||"));
list3 = ",a,b,c,d,e"
Dump(listSetAt(list3,"2", "Z", ",",true)); //Because it includes empty field value ,Z,b,c,d,e
// MemberFunction

dump(list1.listSetAt("4", "Y")); //,a,b,c,Y,e
```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[string.listSetAt()](../objects/string/listsetat.md)