# ListRest()

Gets a list, without its first element.

```
ListRest( list=string, delimiters=string, includeEmptyFields=boolean, offset=number );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* | , |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |
| offset | number | No | specifies how many items to skip from the beginning of the list. default is 1. |  |

# Examples

```cfml

writeOutput(listRest("string,Lucee,susi,LAS")&"<br><br>");

//Member function
strList="0,1,2,3,4";
writeDump(strlist.listRest());

```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[string.listRest()](../objects/string/listrest.md)