# ListRemoveDuplicates()

Removes duplicate values from list.

```
ListRemoveDuplicates( list=string, delimiters=string, ignoreCase=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* | , |
| ignoreCase | boolean | No | if set to true, the duplicate value test will not be case sensitive | false |

# Examples

```cfml
lst = "cat,mouse,dog,cat,cow,goat,sheep,cat,dog";
writeoutput(lst);
writeoutput("<hr>");
// new list with duplicates removed
lst = ListRemoveDuplicates(lst);
writeoutput(lst);
```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[string.listRemoveDuplicates()](../objects/string/listremoveduplicates.md)