# ListReduce()

Iterates over every entry of the given list and calls the closure with every element.

This function will reduce the list to a single value and will return the value.

```
ListReduce( list=string, closure=function, initialValue=object, delimiter=string, includeEmptyFields=boolean, multiCharacterDelimiter=boolean );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | string list to iterate *Alias: string* |  |
| closure | function | Yes | function/closure that implements the following constructor `function(any result, object value, numeric index, string list, string delimiter){ return result; }` *Alias: function, callback, udf* |  |
| initialValue | object | No | initial value passed as part of the first closure call *Alias: initial, initalValue* |  |
| delimiter | string | No | delimiter used to separate the string list | , |
| includeEmptyFields | boolean | No | include empty fields or not | false |
| multiCharacterDelimiter | boolean | No | specifying whether the delimiters parameter specifies a multi-character delimiter. If this parameter is true, the delimiters parameter must specify a single delimiter consisting of multiple characters. This parameter enables the ListToArray function to convert a list such as the following to an array of color names: red:\|orange:\|yellow:\|green:\|blue:\|indigo:\|violet. | true |

# Examples

```cfml

numbers = "1,3,5,7";
reducedVal = listReduce(numbers, function(previousValue, value)
{
return previousValue + value;
},0);
writeOutput("The sum of the digits #numbers# is #reducedVal#");

```







# Categories

[Collections](../../categories/collection.md), [Lists](../../categories/list.md), [Threads](../../categories/thread.md)

# See Also

[string.listReduce()](../objects/string/listreduce.md)