# ListQualify()

Inserts a string at the beginning and end of list elements.

```
ListQualify( list=string, qualifier=string, delimiters=string, elements=string, includeEmptyFields=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| qualifier | string | Yes | string to insert before and after the list elements specified in the elements parameter. |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* | , |
| elements | string | No | which type of element are qualified - all (default): all elements - char: elements that are composed of alphabetic characters | all |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |

# Examples

```cfml

//Simple function with different delimiter(/)
writeOutput(listQualify("string/Lucee/susi/LAS","^","/")&"<br><br>");

//Member function
strList="Lucee,ColdFusion,LAS,SUSI";
writeDump(strlist.listQualify('|'));

```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[string.listQualify()](../objects/string/listqualify.md)