# ListQualifiedToArray()

Copies the elements of a list to an array.

**Introduced:** 5.3.7.17

```
ListQualifiedToArray( list=string, delimiter=string, qualifier=string, qualifierRequired=boolean, includeEmptyFields=boolean );
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list | string | Yes | a string list |  |
| delimiter | string | No | a single character that separate list elements. *Alias: delimiters* | , |
| qualifier | string | No | a single character before and after the list elements. *Alias: qualifiers* | " |
| qualifierRequired | boolean | No | if set to true, all values need to have qualifier (quotes) around them. | false |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well | false |

# Examples

```cfml
	list = "I'love'lucee";
	arr = listQualifiedToArray(list, "'");
	writeDump(arr)
```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md), [Arrays](../../categories/array.md)

# See Also

[string.listQualifiedToArray()](../objects/string/listqualifiedtoarray.md)